/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.gui.components;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import net.nooj4nlp.controller.TextEditorShell.TextEditorShellController;
import net.nooj4nlp.engine.TuGraph;
import net.nooj4nlp.gui.actions.shells.modify.UnitSelectionListener;
import net.nooj4nlp.gui.shells.TextEditorShell;

public class CustomJSpinner
extends JSpinner {
    private static final long serialVersionUID = 5086608640336145412L;
    private TextEditorShell textShell;
    private int upperLimit;
    private StyledDocument doc;
    private JTextPane textPane;
    private TextEditorShellController controller;

    public CustomJSpinner(TextEditorShell textShell, int upperLimit) {
        this.textShell = textShell;
        this.controller = textShell.getTextController();
        this.upperLimit = upperLimit;
        this.textPane = this.textShell.getTextPane();
        this.setModel(new SpinnerNumberModel(1, 1, upperLimit, 1));
        ((JSpinner.DefaultEditor)this.getEditor()).getTextField().setEditable(true);
        this.doc = this.textPane.getStyledDocument();
        this.doc.putProperty("__EndOfLine__", "\n");
        Style active = this.textPane.addStyle("Active", null);
        StyleConstants.setForeground(active, Color.black);
        Style inactive = this.textPane.addStyle("Inactive", null);
        StyleConstants.setForeground(inactive, Color.gray);
        Style redStyle = this.textPane.addStyle("Red", null);
        StyleConstants.setForeground(redStyle, Color.RED);
        Style blueStyle = this.textPane.addStyle("Blue", null);
        StyleConstants.setForeground(blueStyle, Color.BLUE);
        Style greenStyle = this.textPane.addStyle("Green", null);
        StyleConstants.setForeground(greenStyle, new Color(20, 180, 62));
        Style blackStyle = this.textPane.addStyle("Black", null);
        StyleConstants.setForeground(blackStyle, Color.BLACK);
        StyleConstants.setUnderline(blackStyle, true);
    }

    public void setCustomValue(int value) {
        this.setValue(value);
        this.controller.rtbTextUpdate(false);
        int currentAddress = this.controller.getMyText().mft.tuAddresses[(Integer)this.getValue()];
        UnitSelectionListener unitSelectionListener = this.textShell.getUnitSelectionListener();
        this.textPane.removeCaretListener(unitSelectionListener);
        this.textPane.setCaretPosition(currentAddress);
        this.textPane.getCaret().setVisible(true);
        this.textPane.addCaretListener(unitSelectionListener);
        TuGraph tuGraph = this.controller.getTuGraph();
        if (tuGraph == null) {
            return;
        }
        tuGraph.needToBeComputed = true;
        this.scrollTAS(tuGraph);
    }

    @Override
    public Object getPreviousValue() {
        if ((Integer)this.getValue() == this.upperLimit) {
            return null;
        }
        this.setValue((Integer)this.getValue() + 1);
        this.setCustomValue((Integer)this.getValue());
        TuGraph tuGraph = this.controller.getTuGraph();
        if (tuGraph == null) {
            return null;
        }
        tuGraph.needToBeComputed = true;
        this.scrollTAS(tuGraph);
        return null;
    }

    @Override
    public Object getNextValue() {
        if ((Integer)this.getValue() == 1) {
            return null;
        }
        this.setValue((Integer)this.getValue() - 1);
        this.setCustomValue((Integer)this.getValue());
        TuGraph tuGraph = this.controller.getTuGraph();
        if (tuGraph == null) {
            return null;
        }
        tuGraph.needToBeComputed = true;
        this.scrollTAS(tuGraph);
        return null;
    }

    private void scrollTAS(TuGraph tuGraph) {
        if (this.textShell.getChckbxShowTextAnnotation().isSelected()) {
            double selectAllAnnotationsAtPosition = 0.0;
            tuGraph.currentFrameX = 0;
            tuGraph.computeXYcoord(this.textShell.getHiddenPanel(), selectAllAnnotationsAtPosition, -1);
            JButton test = new JButton(Integer.toString((int)selectAllAnnotationsAtPosition));
            test.setLocation(new Point(tuGraph.xCoord, 0));
            test.setUI(new BasicButtonUI(){

                @Override
                public void paint(Graphics g, JComponent component) {
                    int thicknessOfBorders = 3;
                    Graphics2D g2D = (Graphics2D)g;
                    JButton myButton = (JButton)component;
                    Font buttonFont = new Font(myButton.getFont().getName(), 1, myButton.getFont().getSize());
                    myButton.setFont(buttonFont);
                    myButton.setBorder(BorderFactory.createLineBorder(Color.RED, thicknessOfBorders));
                    g2D.setColor(Color.WHITE);
                    g2D.fillRoundRect(thicknessOfBorders, thicknessOfBorders, component.getWidth() - thicknessOfBorders, component.getHeight() - thicknessOfBorders, thicknessOfBorders, thicknessOfBorders);
                    super.paint(g2D, component);
                }
            });
            test.setSize(60, 20);
            this.textShell.getHiddenPanel().removeAll();
            this.textShell.getHiddenPanel().add(test);
            JScrollPane scroll = this.textShell.getPanelScrollPane();
            scroll.getVerticalScrollBar().setValue(0);
            scroll.getHorizontalScrollBar().setValue(tuGraph.xCoord);
            this.textShell.invalidate();
            this.textShell.validate();
            this.textShell.repaint();
        }
    }

    public int getUpperLimit() {
        return this.upperLimit;
    }
}

